/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.util.UUID;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class AttachmentPageIO {

  private AttachmentPageIO() {
  }

  public static AttachmentPage load(String baseDir, UUID uuid, int number) {
    return new Builder(baseDir, uuid, number).build();
  }

  private static class Builder implements AttachmentPage.Builder,
      br.com.objectos.way.core.lang.Builder<AttachmentPage> {

    private final String baseDir;

    private final UUID uuid;

    private final int number;

    public Builder(String baseDir, UUID uuid, int number) {
      this.baseDir = baseDir;
      this.uuid = uuid;
      this.number = number;
    }

    @Override
    public AttachmentPage build() {
      return new AttachmentPageImpl(this);
    }

    @Override
    public String getBaseDir() {
      return baseDir;
    }

    @Override
    public UUID getUuid() {
      return uuid;
    }

    @Override
    public int getNumber() {
      return number;
    }

  }

}