/*
 * Copyright 2011 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.util.List;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class AttachmentPagesGuice implements AttachmentPages {

  @Override
  public Attachment addPagesTo(Attachment attach) {
    if (attach.isValid()) {
      List<AttachmentPage> pages = getPages(attach);
      attach = new FinalAttachment(attach, pages);
    }

    return attach;
  }

  private List<AttachmentPage> getPages(Attachment attach) {
    Mime mime = attach.getMime();

    MimeConv conv;
    switch (mime) {
    default:
    case GIF:
    case JPEG:
    case JPG:
    case PNG:
      conv = new MimeConvNone(attach);
      break;

    case PDF:
      conv = new MimeConvPdf(attach);
      break;
    }

    return conv.extract();
  }

}