/*
 * Copyright 2011 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import br.com.objectos.comuns.web.upload.UploadedFile;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public enum Mime {

  GIF("image/gif"),
  JPEG("image/jpeg"),
  JPG("image/jpeg"),
  PDF("application/pdf"),
  PNG("image/png");

  private final String type;

  private Mime(String type) {
    this.type = type;
  }

  public static Mime valueOf(UploadedFile file) {
    String name = file.getName();
    return valueOfContentType(name);
  }

  public static Mime valueOfContentType(String filename) {
    try {

      String[] parts = filename.split("\\.");
      String ext = parts[parts.length - 1];
      return Mime.valueOf(ext.toUpperCase());

    } catch (IllegalArgumentException e) {

      throw new AttachmentException("Attachment file extension '" + filename + "' not supported.");

    }
  }

  public String getType() {
    return type;
  }

}