/*
 * Copyright 2011 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.io.IOException;
import java.util.List;
import java.util.UUID;

import br.com.objectos.comuns.base.Construtor;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class MimeConvNone implements MimeConv {

  private final Attachment attach;

  public MimeConvNone(Attachment attach) {
    this.attach = attach;
  }

  @Override
  public List<AttachmentPage> extract() {
    try {

      AttachmentPage page = new PageBuilder().novaInstancia();
      Files.copy(attach.getFile(), page.getFile());
      return ImmutableList.of(page);

    } catch (IOException e) {

      throw new AttachmentException("Could not save page of " + attach.getUuid(), e);

    }
  }

  private class PageBuilder implements AttachmentPage.Builder, Construtor<AttachmentPage> {

    @Override
    public AttachmentPage novaInstancia() {
      return new AttachmentPageImpl(this);
    }

    @Override
    public String getBaseDir() {
      return attach.getBaseDir();
    }

    @Override
    public UUID getUuid() {
      return attach.getUuid();
    }

    @Override
    public int getNumber() {
      return 1;
    }

  }

}