/*
 * Copyright 2011 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.io.File;
import java.util.List;
import java.util.UUID;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class ProtoAttachment implements Attachment {

  private final String baseDir;

  private final UUID uuid;

  private final String name;

  private final Mime mime;

  public ProtoAttachment(Builder builder) {
    File baseDirFile = builder.getBaseDir();
    baseDir = baseDirFile.getAbsolutePath();
    uuid = builder.getUuid();
    mime = builder.getMime();
    name = builder.getName();
  }

  @Override
  public boolean isValid() {
    return true;
  }

  @Override
  public Exception getCause() {
    throw new IllegalStateException("This is a valid attachment");
  }

  @Override
  public void delete() {
    throw new UnsupportedOperationException();
  }

  @Override
  public String getBaseDir() {
    return baseDir;
  }

  @Override
  public File getFile() {
    File dir = AttachmentIO.dir(baseDir, uuid);
    return new File(dir, uuid.toString());
  }

  @Override
  public UUID getUuid() {
    return uuid;
  }

  @Override
  public Mime getMime() {
    return mime;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public List<AttachmentPage> getPages() {
    throw new UnsupportedOperationException();
  }

}