/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import com.google.common.base.Preconditions;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class Size {

  private static final Size ORIGINAL = new Size(Integer.MAX_VALUE, Method.ULTRA_QUALITY);

  private final int width;

  private final Method method;

  private Size(int width, Method method) {
    this.width = width;
    this.method = method;
    Preconditions.checkArgument(width > 0, "width must be positive");
    Preconditions.checkNotNull(method, "method must be defined");
  }

  public static Size original() {
    return ORIGINAL;
  }
  public static Size widthOf(int width) {
    return new Size(width, Method.AUTOMATIC);
  }
  public static Size widthOf(int width, Method method) {
    return new Size(width, method);
  }

  static boolean isOriginal(Size size) {
    return ORIGINAL == size;
  }

  public int getWidth() {
    return width;
  }

  public Method getMethod() {
    return method;
  }

}