/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import java.io.IOException;

import javax.servlet.ServletException;

import br.com.objectos.way.ui.AbstractEntityFilter.Context;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class ForwardingEntityFilterContext<T> extends EntityFilterContext<T> {

  private final AbstractEntityFilter.Context<T> delegate;

  public ForwardingEntityFilterContext(Context<T> delegate) {
    this.delegate = delegate;
  }

  @Override
  public T get() {
    return delegate.getEntity();
  }

  @Override
  public void store(Class<?> key, Object value) {
    delegate.store(key, value);
  }

  @Override
  public void sendError(int code) throws IOException {
    delegate.sendError(code);
  }

  @Override
  public void proceed() throws IOException, ServletException {
    delegate.proceed();
  }

}