/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import java.util.Optional;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public interface PageRequestBuilder {

  interface RespondToBuilder {
    GetBuilder get();
  }

  interface GetBuilder extends ConditionBuilder {
    PostBuilder post();
  }

  interface PostBuilder extends ConditionBuilder {}

  interface ConditionBuilder {
    SayBuilder<PageRequest> always();
    SayBuilder<PageRequest> otherwise();

    WhenBuilder when(Class<?> key);
  }

  interface WhenBuilder {
    SayBuilder<ConditionBuilder> notPresent();
  }

  interface SayBuilder<T> {
    T sayOk();
    T sayNotFound();
  }

  <T> PageRequestBuilder put(Class<T> key, Optional<? extends T> optional);

  <T> PageRequestBuilder put(Class<T> key, com.google.common.base.Optional<? extends T> optional);

  <T> PageRequestBuilder put(Class<T> key, T value);

  RespondToBuilder respondTo();

}