/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public interface PageUIBuilder {

  interface PageTitleBuilder {
    PageTitleDisplayBuilder display(String text);
  }

  interface PageTitleDisplayBuilder {
    PageTitleDoneBuilder done();
    PageTitleDoneBuilder withSeparator(String separator);
  }

  interface PageTitleDoneBuilder {
    BreadcrumbBuilder breadcrumb();
  }

  interface BreadcrumbBuilder {
    BreadcrumbDisplayBuilder display(String text);
    BreadcrumbDoneBuilder done();
  }

  interface BreadcrumbDisplayBuilder {
    BreadcrumbBuilder linkTo(String link);
  }

  interface BreadcrumbDoneBuilder {
    ContextBuilder context();
  }

  interface ContextBuilder {
    ContextBuilder accept(ContextVisitor visitor);
    ContextBuilder put(String var, Object value);
    ContextDoneBuilder done();
  }

  interface ContextDoneBuilder extends MoreBuilder {}

  interface MoreBuilder {
    PageUI show(AbstractPage page);
  }

  PageTitleBuilder pageTitle();

}