/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import br.com.objectos.way.core.lang.Builder;

import com.google.common.base.Preconditions;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class WayImgUrl {

  private final String development;
  private final String production;

  private WayImgUrl(String development, String production) {
    this.development = development;
    this.production = production;
  }

  public static ImgUrlBuilder builder() {
    return new ImgUrlBuilder();
  }

  String getText(BaseUrl baseUrl, StageUI stage) {
    return String.format("%s%s", baseUrl, stage.get(development, production));
  }

  public static class ImgUrlBuilder implements Builder<WayImgUrl> {

    private String development = "";

    private String production = "";

    @Override
    public WayImgUrl build() {
      return new WayImgUrl(development, production);
    }

    public ImgUrlBuilder development(String development) {
      this.development = Preconditions.checkNotNull(development);
      return this;
    }

    public ImgUrlBuilder production(String production) {
      this.production = Preconditions.checkNotNull(production);
      return this;
    }

  }

}