/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.builder;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public abstract class Component {

  private static final String INDENT = "  ";
  private static final String NEWLINE = System.getProperty("line.separator");

  private final List<UIObject> children = newArrayList();

  private final StringBuilder toString = new StringBuilder();

  private boolean written = false;

  protected abstract int getDepth();

  protected void addChild(UIObject child) {
    UIObject indented = child.nextDepth();
    this.children.add(indented);
  }

  protected boolean hasChildren() {
    return !children.isEmpty();
  }

  protected void startTag(String tag) {
    write(String.format("<%s>", tag));
  }

  protected void closeTag(String tag) {
    write(String.format("</%s>", tag));
  }

  protected void write(Object o) {
    String raw = o.toString();
    toString.append(raw);
  }

  protected void writeIndent() {
    for (int i = 0; i < getDepth(); i++) {
      toString.append(INDENT);
    }
  }

  protected void writeNewLine() {
    toString.append(NEWLINE);
  }

  protected void writeStartTag() {
  }

  protected void writeChildren() {
    for (UIObject child : children) {
      write(child);
    }
  }

  protected void writeEndTag() {
  }

  @Override
  public String toString() {
    if (!written) {
      writeStartTag();
      writeChildren();
      writeEndTag();
      written = true;
    }
    return toString.toString();
  }

}