/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.builder;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class Html {

  private Html() {
  }

  public static HtmlA a() {
    return new HtmlAPojo();
  }

  public static HtmlButton button() {
    return new HtmlButtonPojo();
  }

  public static HtmlDiv div() {
    return new HtmlDivPojo();
  }

  public static HtmlForm form() {
    return new HtmlFormPojo();
  }

  public static HtmlH h1() {
    return new HtmlHPojo("h1");
  }

  public static HtmlH h2() {
    return new HtmlHPojo("h2");
  }

  public static HtmlH h3() {
    return new HtmlHPojo("h3");
  }

  public static HtmlH h4() {
    return new HtmlHPojo("h4");
  }

  public static HtmlH h5() {
    return new HtmlHPojo("h5");
  }

  public static HtmlH h6() {
    return new HtmlHPojo("h6");
  }

  public static HtmlHr hr() {
    return new HtmlHrPojo();
  }

  public static HtmlInput input() {
    return new HtmlInputPojo();
  }

  public static HtmlLi li() {
    return new HtmlLiPojo();
  }

  public static HtmlOl ol() {
    return new HtmlOlPojo();
  }

  public static HtmlParagraph p() {
    return new HtmlParagraphPojo();
  }

  public static HtmlUl ul() {
    return new HtmlUlPojo();
  }

  public static HtmlSpan span() {
    return new HtmlSpanPojo();
  }

  public static HtmlSelect select() {
    return new HtmSelectPojo();
  }

  public static HtmlTable table() {
    return new HtmlTablePojo();
  }

  public static HtmlTbody tbody() {
    return new HtmlTbodyPojo();
  }

  public static HtmlTd td() {
    return new HtmlTdPojo();
  }

  public static HtmlTh th() {
    return new HtmlThPojo();
  }

  public static HtmlThead thead() {
    return new HtmlTheadPojo();
  }

  public static HtmlTr tr() {
    return new HtmlTrPojo();
  }

  public static HtmlOption option() {
    return new HtmlOptionPojo();
  }

}