/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.builder;

/**
 * @author carolene.bertoldi@objectos.com.br (Carolene Reis Silva Bertoldi)
 */
public class HtmlButtonPojo extends AbstractHtmlElement<HtmlButton> implements HtmlButton {

  public HtmlButtonPojo() {
    super("button");
  }

  @Override
  HtmlButton self() {
    return this;
  }

  @Override
  public HtmlButton type(String type) {
    attr("type", type);
    return self();
  }

  @Override
  public HtmlButton multiSubmit(String multiSubmit) {
    attr("data-way-multi-submit", multiSubmit);
    return self();
  }

}