/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.builder;

/**
 * @author carolene.bertoldi@objectos.com.br (Carolene Bertoldi)
 */
class HtmlFormPojo extends AbstractHtmlElement<HtmlForm> implements HtmlForm {

  public HtmlFormPojo() {
    super("form");
  }

  @Override
  HtmlForm self() {
    return this;
  }

  @Override
  public HtmlForm action(String url) {
    String _url = "{{bricks.baseUrl}}/" + url;
    attr("action", _url);
    return self();
  }

  @Override
  public HtmlForm dataWayForm(String dataWayForm) {
    attr("data-way-form", dataWayForm);
    return self();
  }

  @Override
  public HtmlForm method(MethodFormType type) {
    String method = type.name();
    attr("method", method.toLowerCase());
    return self();
  }

}