/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.builder;

/**
 * @author carolene.bertoldi@objectos.com.br (Carolene Bertoldi)
 */
class HtmlInputPojo extends AbstractHtmlElement<HtmlInput> implements HtmlInput {

  public HtmlInputPojo() {
    super("input");
  }

  @Override
  public HtmlInput name(String name) {
    attr("name", name);
    return self();
  }

  @Override
  public HtmlInput type(InputType type) {
    String _type = type.name();
    attr("type", _type.toLowerCase());
    return self();
  }

  @Override
  public HtmlInput value(String value) {
    attr("value", value);
    return self();
  }

  @Override
  HtmlInput self() {
    return this;
  }

  @Override
  boolean selfClosing() {
    return true;
  }

}