/*
 * LocalDateDeserializers.java criado em 06/05/2015
 *
 * Propriedade de Objectos Fábrica de Software LTDA.
 * Reprodução parcial ou total proibida.
 */
package br.com.objectos.way.ui.json;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class LocalDateDeserializers {

  private LocalDateDeserializers() {
  }

  public static class ISO extends Deserializer {
    public ISO() {
      super("yyyy-MM-dd");
    }
  }

  public static class DD_MM_YY extends Deserializer {
    public DD_MM_YY() {
      super("dd/MM/yy");
    }
  }

  public static class DD_MM_YYYY extends Deserializer {
    public DD_MM_YYYY() {
      super("dd/MM/yyyy");
    }
  }

  public static class MM_DD_YYYY extends Deserializer {
    public MM_DD_YYYY() {
      super("MM/dd/yyyy");
    }
  }

  private static abstract class Deserializer extends JsonDeserializer<LocalDate> {

    private final DateTimeFormatter formatter;

    public Deserializer(String pattern) {
      formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt)
        throws IOException, JsonProcessingException {

      LocalDate res = null;

      JsonToken t = jp.getCurrentToken();

      if (t == JsonToken.VALUE_STRING) {
        try {
          String text = jp.getText().trim();
          res = LocalDate.parse(text, formatter);
        } catch (DateTimeParseException iae) {

        }
      }

      return res;

    }

  }

}