/*
 * LocalDateSerializer.java criado em 06/05/2015
 *
 * Propriedade de Objectos Fábrica de Software LTDA.
 * Reprodução parcial ou total proibida.
 */
package br.com.objectos.way.ui.json;

import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class LocalDateSerializer extends JsonSerializer<LocalDate> {

  private static final DateTimeFormatter ISO = DateTimeFormatter.ISO_LOCAL_DATE;
  private static final DateTimeFormatter DD_MM_YYYY = DateTimeFormatter.ofPattern("dd/MM/yyyy");
  private static final DateTimeFormatter DD_MM_YY = DateTimeFormatter.ofPattern("dd/MM/yy");

  @Override
  public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider)
      throws IOException, JsonProcessingException {

    jgen.writeStartObject();
    jgen.writeObjectField("iso", ISO.format(value));
    jgen.writeObjectField("dd_mm_yyyy", DD_MM_YYYY.format(value));
    jgen.writeObjectField("dd_mm_yy", DD_MM_YY.format(value));
    jgen.writeEndObject();

  }

}