/*
 * ValorFinanceiroDeserializer.java criado em 17/10/2012
 * 
 * Propriedade de Objectos Fábrica de Software LTDA.
 * Reprodução parcial ou total proibida.
 */
package br.com.objectos.way.ui.json;

import java.io.IOException;
import java.text.ParseException;

import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;

import br.com.objectos.comuns.base.text.DecimalFormats;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class ValorFinanceiroDeserializer extends JsonDeserializer<Double> {

  @Override
  public Double deserialize(JsonParser jp, DeserializationContext ctxt)
      throws IOException, JsonProcessingException {

    Double res = null;

    JsonToken t = jp.getCurrentToken();

    if (t == JsonToken.VALUE_STRING) {
      try {
        String text = jp.getText().trim();
        Number number = DecimalFormats.newCurrencyWithLocale("pt").parse(text);
        res = number.doubleValue();
      } catch (ParseException e) {
      }
    }

    return res;

  }

}