/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.view;

import com.google.common.base.Objects;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public abstract class MarkupAttribute {

  private final String name;

  MarkupAttribute(String name) {
    this.name = name;
  }

  public static MarkupAttributeInt intAttr(String name) {
    return new MarkupAttributeInt(name);
  }

  public static MarkupAttributeString stringAttr(String name) {
    return new MarkupAttributeString(name);
  }

  @Override
  public final int hashCode() {
    return Objects.hashCode(name);
  }

  @Override
  public final boolean equals(final Object obj) {
    if (obj == this) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (obj instanceof MarkupAttribute) {
      final MarkupAttribute that = (MarkupAttribute) obj;
      return Objects.equal(this.name, that.name);
    } else {
      return false;
    }
  }

  String toString(String value) {
    return String.format("%s=\"%s\"", name, value);
  }

}