/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.view;

import java.util.List;

import com.google.common.base.Joiner;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class MarkupEmitter {

  private final StringBuilder builder = new StringBuilder();

  public void join(String separator, List<MarkupObject> objects) {
    if (!objects.isEmpty()) {
      builder.append(separator);
    }

    String text = Joiner.on(separator)
        .join(objects)
        .toString();
    builder.append(text);
  }

  public void write(String text) {
    builder.append(text);
  }

  public void write(String template, Object... args) {
    String text = String.format(template, args);
    builder.append(text);
  }

  @Override
  public String toString() {
    return builder.toString();
  }

}