/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.view;

import java.util.List;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class MarkupObjectMap {

  private final List<MarkupObject> list;

  private MarkupObjectMap(List<MarkupObject> list) {
    this.list = list;
  }

  public static MarkupObjectMap mapOf(MarkupObject... objects) {
    List<MarkupObject> list = ImmutableList.copyOf(objects);
    return new MarkupObjectMap(list);
  }

  public void writeAttributes(MarkupEmitter emitter) {
    List<MarkupObject> attributes = FluentIterable.from(list)
        .filter(MarkupObject.IS_ATTRIBUTE)
        .toList();
    emitter.join(" ", attributes);
  }

  public void writeChildren(MarkupEmitter emitter) {
    List<MarkupObject> children = FluentIterable.from(list)
        .filter(MarkupObject.IS_CHILD)
        .toList();

    emitter.join("", children);
  }

}