/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.view;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
abstract class MarkupTag {

  private final Tag tag;

  MarkupTag(MarkupTagBuilderPojo<?, ?> builder) {
    tag = builder.getTag();
  }

  public String toString(MarkupObjectMap objectMap) {
    Writer writer = new Writer();
    return writer.write(objectMap);
  }

  private class Writer {

    private final MarkupEmitter emitter = new MarkupEmitter();

    public String write(MarkupObjectMap objectMap) {
      tag.openStartTag(emitter);
      objectMap.writeAttributes(emitter);
      tag.closeStartTag(emitter);

      objectMap.writeChildren(emitter);

      tag.endTag(emitter);

      return emitter.toString();
    }

  }

}