/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
abstract class AbstractUploadScript implements Runnable {

  private final Object lock = new Object();

  private final ExecutorService executor;

  private final ConcurrentMap<Object, AbstractUploadScript> map;

  private final HasKey async;

  private Future<?> future;

  public AbstractUploadScript(ExecutorService executor,
                              ConcurrentMap<Object, AbstractUploadScript> map,
                              HasKey async) {
    this.executor = executor;
    this.map = map;
    this.async = async;
  }

  public void sumit() {
    if (future == null) {
      synchronized (lock) {
        if (future == null) {
          future = executor.submit(this);
        }
      }
    }
  }

  @Override
  public void run() {
    try {
      onStart();
      tryToCall();
      onSuccess();

    } catch (Exception e) {
      onError(e);

    } finally {
      finish();

    }
  }

  protected void onStart() {
  }

  protected void onSuccess() {
  }

  protected void onError(Exception e) {
  }

  protected void onFinish() {
  }

  void finish() {
    Object key = async.getKey();
    map.remove(key);
    onFinish();
  }

  protected abstract void tryToCall() throws Exception;

}