/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.io.File;

import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public abstract class Execute<T> {

  final UploadCtx ctx;

  Execute(UploadCtx ctx) {
    this.ctx = ctx;
  }

  public abstract RedirectWith<T> redirectWith(UploadRedirect<T> redirect);

  public abstract Reply<?> reply();

  public abstract Reply<?> replyWith(UploadReplier<T> replier);

  static <T> Execute<T> execute(UploadCtx ctx, UploadSingleAction<T> a, File file) {
    try {
      UploadedRequest request = ctx.getRequest();
      T pojo = a.execute(file, request);
      return new ExecuteValid<T>(ctx, pojo);
    } catch (Exception e) {
      return new ExecuteInvalid<T>(ctx, e);
    }
  }

  static <T> Execute<T> executeAsync(UploadCtx ctx, UploadSingleAsync<T> a, File file) {
    try {
      UploadedRequest request = ctx.getRequest();
      T pojo = a.execute(file, request);
      ctx.submitSingle(ctx, a, pojo, file);
      return new ExecuteValid<T>(ctx, pojo);
    } catch (Exception e) {
      return new ExecuteInvalid<T>(ctx, e);
    }
  }

  static <T> Execute<T> execute(UploadCtx ctx, UploadUnzipAction<T> a, UploadedZip file) {
    try {
      UploadedRequest request = ctx.getRequest();
      T pojo = a.execute(file, request);
      return new ExecuteValid<T>(ctx, pojo);
    } catch (Exception e) {
      return new ExecuteInvalid<T>(ctx, e);
    }
  }

  static <K, T> Execute<T> executeAsync(UploadCtx ctx, UploadUnzipAsync<T> a, UploadedZip file) {
    try {
      UploadedRequest request = ctx.getRequest();
      T pojo = a.execute(file, request);
      ctx.submitUnzip(ctx, a, pojo, file);
      return new ExecuteValid<T>(ctx, pojo);
    } catch (Exception e) {
      return new ExecuteInvalid<T>(ctx, e);
    }
  }

  T getPojo() {
    return null;
  }

}