/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.util.List;

import com.google.common.collect.ImmutableList;
import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class ExecuteInvalid<T> extends Execute<T> {

  private final List<Exception> exceptions;

  public ExecuteInvalid(UploadCtx ctx, List<Exception> exceptions) {
    super(ctx);
    this.exceptions = exceptions;
  }

  public ExecuteInvalid(UploadCtx ctx, Exception e) {
    super(ctx);
    this.exceptions = ImmutableList.of(e);
  }

  @Override
  public RedirectWith<T> redirectWith(UploadRedirect<T> redirect) {
    UploadRedirector redirector = ctx.getRedirector();
    String url = redirect.onError(redirector);
    return new RedirectWithInvalid<T>(ctx, url, exceptions);
  }

  @Override
  public Reply<?> reply() {
    UploadError error = UploadError.of(exceptions);
    ctx.store(error);
    return Reply.saying().ok();
  }

  @Override
  public Reply<?> replyWith(UploadReplier<T> replier) {
    return replier.onError(exceptions);
  }

  public List<Exception> getExceptions() {
    return exceptions;
  }

}