/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.io.File;
import java.util.List;

import br.com.objectos.comuns.web.upload.UploadRequestException;

import com.google.common.collect.ImmutableList;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class FirstFromRequestInvalid extends FirstFromRequest {

  private final List<Exception> exceptions;

  public FirstFromRequestInvalid(UploadCtx ctx, List<UploadRequestException> exceptions) {
    super(ctx);
    this.exceptions = ImmutableList.<Exception> builder()
        .addAll(exceptions)
        .build();
  }

  @Override
  public AndSaveTo andSaveToDir(File dir) {
    return new AndSaveToInvalid(ctx, exceptions);
  }

  @Override
  public AndSaveTo andSaveToFile(File file) {
    return new AndSaveToInvalid(ctx, exceptions);
  }

  @Override
  public <T> Execute<T> execute(UploadSingleAction<T> action) {
    return new ExecuteInvalid<T>(ctx, exceptions);
  }

  public List<Exception> getExceptions() {
    return exceptions;
  }

}