/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.io.File;
import java.util.List;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class UnzipValid extends Unzip {

  private final UploadedZip uploadedZip;

  public UnzipValid(UploadCtx ctx, File file, List<File> entries) {
    super(ctx);
    this.uploadedZip = new UploadedZipValid(file, entries);
  }

  @Override
  public <T> Execute<T> execute(UploadUnzipAction<T> action) {
    return Execute.execute(ctx, action, uploadedZip);
  }

  @Override
  public <T> Execute<T> executeAsync(UploadUnzipAsync<T> async) {
    return Execute.executeAsync(ctx, async, uploadedZip);
  }

  @Override
  public UploadedZip getUploadedZip() {
    return uploadedZip;
  }

}