/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.util.List;

import br.com.objectos.way.ui.form.FormResponseBuilder;

import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class UploadReplier<T> {

  public Reply<?> onError(List<Exception> exceptions, String url) {
    return onErrorBuilder(exceptions)
        .redirectTo(url)
        .reply();
  }

  public Reply<?> onError(List<Exception> exceptions) {
    return onErrorBuilder(exceptions).reply();
  }

  public Reply<?> onSuccess(T pojo) {
    return new FormResponseBuilder()
        .reply();
  }

  public Reply<?> onSuccess(T pojo, String url) {
    return new FormResponseBuilder()
        .redirectTo(url)
        .reply();
  }

  private FormResponseBuilder onErrorBuilder(List<Exception> exceptions) {
    FormResponseBuilder builder = new FormResponseBuilder();

    for (Exception exception : exceptions) {
      String message = exception.getMessage();
      builder.addMessage(message);
    }

    return builder;
  }

}