/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this zip except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class UploadUnzipScript<T> extends AbstractUploadScript {

  private final UploadUnzipAsync<T> async;

  private final T pojo;

  private final UploadedZip zip;

  private final UploadedRequest request;

  public UploadUnzipScript(ExecutorService executor,
                           ConcurrentMap<Object, AbstractUploadScript> map,
                           UploadUnzipAsync<T> async,
                           T pojo,
                           UploadedZip zip,
                           UploadedRequest request) {
    super(executor, map, async);
    this.async = async;
    this.pojo = pojo;
    this.zip = zip;
    this.request = request;
  }

  @Override
  protected void tryToCall() throws Exception {
    async.executeAsync(pojo, zip, request);
  }

  @Override
  protected void onStart() {
    async.onStart();
  }

  @Override
  protected void onSuccess() {
    async.onSuccess();
  }

  @Override
  protected void onError(Exception e) {
    async.onError(e);
  }

  @Override
  protected void onFinish() {
    async.onFinish();
  }

}