/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload.async;

import org.joda.time.DateTime;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class AsyncFilePojo implements AsyncFile {

  private final String name;

  private final DateTime dateTime;

  private final AsyncFileStatus status;

  public AsyncFilePojo(Builder builder) {
    name = builder.getName();
    dateTime = builder.getDateTime();
    status = builder.getStatus();
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public DateTime getDateTime() {
    return dateTime;
  }

  @Override
  public AsyncFileStatus getStatus() {
    return status;
  }

}