/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload.async;

import java.io.File;
import java.io.IOException;

import com.google.common.base.Charsets;
import com.google.common.io.Files;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public enum AsyncFileStatus {

  NEW,
  PROCESSING,
  DONE,
  ERROR;

  private static final Logger logger = LoggerFactory.getLogger(AsyncFileStatus.class);

  public void write(File file) {
    try {
      File statusFile = statusFileOf(file);
      Files.write(name(), statusFile, Charsets.UTF_8);
    } catch (IOException e) {
      logger.error("Couldn't write status file", e);
    }
  }

  public static AsyncFileStatus read(File file) {
    try {
      File statusFile = statusFileOf(file);
      String text = Files.toString(statusFile, Charsets.UTF_8);
      return AsyncFileStatus.valueOf(text);
    } catch (IllegalArgumentException e) {
      return AsyncFileStatus.NEW;
    } catch (IOException e) {
      return AsyncFileStatus.NEW;
    }
  }

  private static File statusFileOf(File file) {
    File dir = file.getParentFile();
    String name = file.getName();
    name = name + ".status";
    return new File(dir, name);
  }

}