/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.comuns.web.upload;

import static com.google.common.collect.Maps.newHashMap;

import java.util.Map;

import br.com.objectos.way.ui.LocalDateFormat;

import org.joda.time.LocalDate;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class MapUploadedForm implements UploadedForm {

  private final Map<String, UploadedFormField> map;

  public MapUploadedForm() {
    map = newHashMap();
  }

  public void add(UploadedFormField field) {
    map.put(field.getName(), field);
  }

  @Override
  public String param(String key) {
    String res = null;

    if (map.containsKey(key)) {
      UploadedFormField field = map.get(key);
      res = field.getValue();
    }

    return res;
  }

  @Override
  public boolean booleanParam(String param) {
    String value = param(param);
    return value == null;
  }

  @Override
  public <E extends Enum<E>> E enumParam(Class<E> enumClass, String param) {
    E res = null;

    String value = param(param);
    if (value != null) {
      try {
        res = Enum.valueOf(enumClass, value);
      } catch (IllegalArgumentException e) {

      }
    }

    return res;
  }

  @Override
  public LocalDate localDateParam(String param) {
    return localDateParam(LocalDateFormat.ISO, param);
  }

  @Override
  public LocalDate localDateParam(LocalDateFormat format, String param) {
    String value = param(param);
    return format.parse(value);
  }

  @Override
  public Double doubleParam(String param) {
    try {
      String value = param(param);
      return Double.valueOf(value);
    } catch (NullPointerException e) {
      return null;
    } catch (NumberFormatException e) {
      return null;
    }
  }
  @Override
  public Integer integerParam(String param) {
    try {
      String value = param(param);
      return Integer.valueOf(value);
    } catch (NullPointerException e) {
      return null;
    } catch (NumberFormatException e) {
      return null;
    }
  }
  @Override
  public Long longParam(String param) {
    try {
      String value = param(param);
      return Long.valueOf(value);
    } catch (NullPointerException e) {
      return null;
    } catch (NumberFormatException e) {
      return null;
    }
  }

}