/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.comuns.web.upload;

import br.com.objectos.way.ui.LocalDateFormat;

import org.joda.time.LocalDate;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public interface UploadedForm {

  String param(String param);

  boolean booleanParam(String param);

  <E extends Enum<E>> E enumParam(Class<E> enumClass, String param);

  LocalDate localDateParam(String param);
  LocalDate localDateParam(LocalDateFormat format, String param);

  Double doubleParam(String param);

  Integer integerParam(String param);

  Long longParam(String param);

}