/*
 * PageTitle.java criado em 20/05/2014
 * 
 * Propriedade de Objectos Fábrica de Software LTDA.
 * Reprodução parcial ou total proibida.
 */
package br.com.objectos.way.ui;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class PageTitle {

  private final List<String> items = newArrayList();

  private String separator;
  private boolean reverse = true;

  public void display(String text) {
    items.add(text);
  }

  public void doNotReverse() {
    reverse = false;
  }

  public void resume(PageTitle pageTitle) {
    this.items.addAll(pageTitle.items);
  }

  public void withSeparator(String separator) {
    this.separator = separator;
  }

  String get() {
    List<String> parts = items;

    if (reverse) {
      parts = Lists.reverse(items);
    }

    String title = "";

    if (separator != null) {
      title = Joiner.on(separator).join(parts);
    }

    return title;
  }

  List<String> getItems() {
    return items;
  }

}