/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import org.codehaus.jackson.JsonGenerator;

import com.google.inject.Inject;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class PageWay implements IsJsonSerializable {

  private final BaseUrl baseUrl;
  private final WayImgUrl imgUrl;
  private final StageUI stage;
  private final WayUUID uuid;

  private Breadcrumb breadcrumb;
  private PageTitle pageTitle;

  @Inject
  public PageWay(BaseUrl baseUrl, WayImgUrl imgUrl, StageUI stage, WayUUID uuid) {
    this.baseUrl = baseUrl;
    this.imgUrl = imgUrl;
    this.stage = stage;
    this.uuid = uuid;
  }

  public void decorate(Breadcrumb breadcrumb, PageTitle pageTitle) {
    this.breadcrumb = breadcrumb;
    this.pageTitle = pageTitle;
  }

  @Override
  public void toJson(JsonGenerator jgen) {
    Page page = new Page(breadcrumb, pageTitle);

    WayUI.toJsonHelper(jgen)
        .add("baseUrl", baseUrl.get())
        .add("imgUrl", imgUrl.getText(baseUrl, stage))
        .add("page", page)
        .add("stage", stage)
        .add("uuid", uuid.get())
        .write();
  }

  private static class Page implements IsJsonSerializable {

    private final Breadcrumb breadcrumb;
    private final PageTitle pageTitle;

    public Page(Breadcrumb breadcrumb, PageTitle pageTitle) {
      this.breadcrumb = breadcrumb;
      this.pageTitle = pageTitle;
    }

    @Override
    public void toJson(JsonGenerator jgen) {
      WayUI.toJsonHelper(jgen)
          .add("breadcrumb", breadcrumb.get())
          .add("title", pageTitle.get())
          .add("titles", pageTitle.getItems())
          .write();
    }

  }

}