/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import br.com.objectos.way.relational.Page;
import br.com.objectos.way.relational.SimplePage;

/**
 * @author carolene.bertoldi@objectos.com.br (Carolene Bertoldi)
 */
public class PagerlessWrapper extends ForwardingRequestWrapper {

  private final RequestWrapper delegate;
  private final int length;

  public PagerlessWrapper(RequestWrapper request) {
    this.delegate = request;
    this.length = Integer.MAX_VALUE;
  }

  public PagerlessWrapper(RequestWrapper request, int length) {
    this.delegate = request;
    this.length = length;
  }

  @Override
  protected RequestWrapper delegate() {
    return delegate;
  }

  @Override
  public final Page getPage() {
    return SimplePage.build()
        .startAt(0)
        .withLengthOf(length)
        .get();
  }

}