/*
 * Replies.java criado em 21/12/2013
 * 
 * Propriedade de Objectos Fábrica de Software LTDA.
 * Reprodução parcial ou total proibida.
 */
package br.com.objectos.way.ui;

import static com.google.common.collect.Maps.newHashMap;

import java.io.IOException;
import java.util.Map;

import br.com.objectos.way.base.io.BinaryFile;

import com.google.sitebricks.client.transport.Raw;
import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class Replies {

  private Replies() {
  }

  public static Reply<?> download(BinaryFile file) {
    try {

      byte[] data = file.toByteArray();
      String filename = file.getName();
      return download(data, filename);

    } catch (IOException e) {

      return Reply.saying().error();

    }
  }

  public static Reply<?> download(byte[] data, String filename) {
    Map<String, String> headers = newHashMap();
    headers.put("Content-Disposition", "attachment; filename=\"" + filename + "\"");
    return Reply.with(data).as(Raw.class).headers(headers);
  }

}