/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.form;

import static com.google.common.collect.Lists.newArrayList;

import java.util.List;

import br.com.objectos.way.ui.Context;
import br.com.objectos.way.ui.form.Errors.FieldError;
import br.com.objectos.way.ui.form.Errors.FormError;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class FormJson implements FormResponse {

  private final Context context;

  private final List<Error> errors;

  private final List<Error> formErrors;

  private final String redirectUrl;

  private FormJson(Context context,
                   List<Error> errors,
                   List<Error> formErrors,
                   String redirectUrl) {
    this.context = context;
    this.errors = errors;
    this.formErrors = formErrors;
    this.redirectUrl = redirectUrl;
  }

  public static FormResponse of(Context context, List<Error> unfiltered, String redirectUrl) {
    List<Error> errors = newArrayList();
    List<Error> formErrors = newArrayList();

    for (Error error : unfiltered) {
      if (error instanceof FieldError) {
        errors.add(error);
      }
      if (error instanceof FormError) {
        formErrors.add(error);
      }
    }

    return new FormJson(context, errors, formErrors, redirectUrl);
  }

  @Override
  public Context getContext() {
    return context;
  }

  @Override
  public List<Error> getErrors() {
    return errors;
  }

  @Override
  public List<Error> getFormErrors() {
    return formErrors;
  }

  @Override
  public String getRedirectUrl() {
    return redirectUrl;
  }

  @Override
  public boolean isValid() {
    return errors.isEmpty() && formErrors.isEmpty();
  }

}