/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.json;

import java.io.IOException;

import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

import br.com.objectos.comuns.matematica.financeira.Percentual;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class PercentualSerializer extends JsonSerializer<Percentual> {

  @Override
  public void serialize(Percentual value, JsonGenerator jgen, SerializerProvider provider)
      throws IOException, JsonProcessingException {

    double doubleValue = value.doubleValue();
    String text = value.toString();

    jgen.writeStartObject();
    jgen.writeBooleanField("zero", value.isZero());
    jgen.writeObjectField("doubleValue", doubleValue * 100d);
    jgen.writeObjectField("text", text);
    jgen.writeEndObject();

  }

}