/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.util.List;

import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class RedirectWithInvalid<T> extends RedirectWith<T> {

  final List<Exception> exceptions;

  public RedirectWithInvalid(UploadCtx ctx, String url, List<Exception> exceptions) {
    super(ctx, url);
    this.exceptions = exceptions;
  }

  @Override
  public Reply<?> reply() {
    UploadError error = UploadError.of(exceptions);
    ctx.store(error);
    return Reply.saying().redirect(url);
  }

  @Override
  public Reply<?> replyWith(UploadReplier<T> replier) {
    return replier.onError(exceptions, url);
  }

}