/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.io.File;

import br.com.objectos.comuns.web.upload.UploadedFile;
import br.com.objectos.comuns.web.upload.UploadedForm;
import br.com.objectos.way.ui.BaseUrl;
import br.com.objectos.way.ui.WebSession;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class UploadCtx {

  private final UploadedForm form;
  private final UploadRedirector redirector;
  private final WebSession session;
  private final UploadServer uploadServer;

  private UploadedRequest request;

  public UploadCtx(BaseUrl baseUrl, UploadedForm form, WebSession session, UploadServer uploadServer) {
    this.form = form;
    this.redirector = new UploadRedirector(baseUrl, form);
    this.session = session;
    this.uploadServer = uploadServer;
    this.request = new UploadedRequestPojo(form, null);
  }

  public UploadCtx withFile(UploadedFile file) {
    this.request = new UploadedRequestPojo(form, file);
    return this;
  }

  public UploadedForm getForm() {
    return form;
  }

  public UploadedRequest getRequest() {
    if (request == null) {
      throw new IllegalStateException("Ctx has no UploadedRequest.");
    }
    return request;
  }

  public UploadRedirector getRedirector() {
    return redirector;
  }

  public void store(UploadError error) {
    error.logExceptions();
    session.set(UploadError.class, error);
  }

  public <T> void submitSingle(UploadCtx ctx, UploadSingleAsync<T> async, T pojo, File file) {
    uploadServer.submitSingle(ctx, async, pojo, file);
  }

  public <T> void submitUnzip(UploadCtx ctx, UploadUnzipAsync<T> async, T pojo, UploadedZip zip) {
    uploadServer.submitUnzip(ctx, async, pojo, zip);
  }

}