/*
 * Copyright 2013 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.upload;

import java.io.File;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class UploadSingleScript<T> extends AbstractUploadScript {

  private final UploadSingleAsync<T> async;

  private final T pojo;

  private final File file;

  private final UploadedRequest request;

  public UploadSingleScript(ExecutorService executor,
                            ConcurrentMap<Object, AbstractUploadScript> map,
                            UploadSingleAsync<T> async,
                            T pojo,
                            File file,
                            UploadedRequest request) {
    super(executor, map, async);
    this.async = async;
    this.pojo = pojo;
    this.file = file;
    this.request = request;
  }

  @Override
  protected void tryToCall() throws Exception {
    async.executeAsync(pojo, file, request);
  }

  @Override
  protected void onStart() {
    async.onStart();
  }

  @Override
  protected void onSuccess() {
    async.onSuccess();
  }

  @Override
  protected void onError(Exception e) {
    async.onError(e);
  }

  @Override
  protected void onFinish() {
    async.onFinish();
  }

}