/*
 * Copyright 2011 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class AttachmentIO {

  private AttachmentIO() {
  }

  public static File dir(String baseDir, UUID uuid) {
    File baseDirFile = new File(baseDir);
    return dir(baseDirFile, uuid);
  }

  public static File dir(File baseDir, UUID uuid) {
    Preconditions.checkArgument(baseDir.isDirectory(), "baseDir must be a valid directory");

    baseDir.mkdirs();

    String filename = uuid.toString();
    String prefix = filename.substring(0, 1);

    File res = new File(baseDir, prefix);
    res.mkdirs();

    return res;
  }

  static File fileOf(File baseDir, UUID uuid) {
    String filename = uuid.toString();
    File subdir = dir(baseDir, uuid);
    return new File(subdir, filename);
  }

  static void write(File baseDir, UUID uuid, InputStream input) throws IOException {
    String filename = uuid.toString();
    File subdir = dir(baseDir, uuid);

    File res = new File(subdir, filename);
    FileOutputStream out = new FileOutputStream(res);
    ByteStreams.copy(input, out);
  }

}