/*
 * Copyright 2011 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.io.File;

import com.google.inject.ImplementedBy;
import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
@ImplementedBy(AttachmentsGuice.class)
public interface Attachments {

  interface FirstFromRequest {
    AndSaveTo andSaveTo(File baseDir);
  }

  interface AndSaveTo {
    <T> Execute<T> execute(AttachmentAction<T> action);
  }

  interface Execute<T> {
    RedirectWith<T> redirectWith(AttachmentRedirect<T> redirect);
    Reply<?> reply();
  }

  interface RedirectWith<T> {
    Reply<?> reply();
  }

  FirstFromRequest getFirstFromRequest();

}