/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.attach;

import java.io.File;
import java.util.List;
import java.util.UUID;

import com.google.common.base.Preconditions;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class FinalAttachment implements Attachment {

  private final Attachment delegate;

  private final List<AttachmentPage> pages;

  public FinalAttachment(Attachment delegate, List<AttachmentPage> pages) {
    Preconditions.checkArgument(delegate.isValid());
    this.delegate = delegate;
    this.pages = pages;
  }

  @Override
  public boolean isValid() {
    return delegate.isValid();
  }

  @Override
  public Exception getCause() {
    return delegate.getCause();
  }

  @Override
  public void delete() {
    delegate.delete();
  }

  @Override
  public String getBaseDir() {
    return delegate.getBaseDir();
  }

  @Override
  public File getFile() {
    return delegate.getFile();
  }

  @Override
  public UUID getUuid() {
    return delegate.getUuid();
  }

  @Override
  public Mime getMime() {
    return delegate.getMime();
  }

  @Override
  public String getName() {
    return delegate.getName();
  }

  @Override
  public List<AttachmentPage> getPages() {
    return pages;
  }

}