/*
 * AbstractPageMeta.java criado em 28/08/2011
 * 
 * Propriedade de Objectos Fábrica de Software LTDA.
 * Reprodução parcial ou total proibida.
 */
package br.com.objectos.way.ui;

import java.util.List;

import br.com.objectos.way.ui.PageMetaBuilder.Display;

import com.google.common.base.Preconditions;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public abstract class AbstractPageMeta implements PageMetaScript {

  private PageMetaBuilder binder;

  @Override
  public final synchronized void configure(PageMetaBuilder builder) {
    // cool!
    // http://code.google.com/p/google-guice/source/browse/tags/2.0/src/com/google/inject/AbstractModule.java#54
    Preconditions.checkState(this.binder == null, "Re-entry is not allowed.");

    this.binder = Preconditions.checkNotNull(builder, "meta");
    try {
      pageMetaFor();
    } finally {
      this.binder = null;
    }
  }

  @Override
  public List<Display> getElements() {
    return binder.getElements();
  }

  protected abstract void pageMetaFor();

  protected Display display(String title) {
    return binder.display(title);
  }

  protected void install(PageMetaScript script) {
    binder.install(script);
  }

  protected PageMetaBuilder binder() {
    return binder;
  }

}