/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import java.util.Set;

import com.google.sitebricks.headless.Reply;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
abstract class PageCondition {

  PageSay say;

  public static PageCondition requestNotPresent(Set<PageCondition> conditions, Class<?> key) {
    RequestNotPresent condition = new RequestNotPresent(key);
    conditions.add(condition);
    return condition;
  }

  public static PageCondition trueValue(Set<PageCondition> conditions) {
    True condition = new True();
    conditions.add(condition);
    return condition;
  }

  public void sayNotFound() {
    say = PageSay.NOT_FOUND;
  }

  public void sayOk() {
    say = PageSay.OK;
  }

  Reply<?> preReply() {
    return say.preReply();
  }

  abstract boolean isSatisfied(PageRequestPojo pojo);

  private static class True extends PageCondition {
    @Override
    boolean isSatisfied(PageRequestPojo pojo) {
      return true;
    }
  }

  private static class RequestNotPresent extends PageCondition {

    private final Class<?> key;

    public RequestNotPresent(Class<?> key) {
      this.key = key;
    }

    @Override
    boolean isSatisfied(PageRequestPojo pojo) {
      Object value = pojo.get(key);
      return value == null;
    }

  }

}