/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import com.google.common.base.Optional;
import com.google.inject.Injector;
import com.google.sitebricks.headless.Reply;
import com.google.sitebricks.headless.Request;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
class PageUIPojo implements PageUI {

  private final Injector injector;
  private final PageTitle pageTitle;
  private final Breadcrumb breadcrumb;
  private final Context context;
  private final Class<? extends AbstractPage> pageClass;

  public PageUIPojo(PageUIBuilderPojo builder) {
    injector = builder.getInjector();
    pageTitle = builder.getPageTitle();
    breadcrumb = builder.getBreadcrumb();
    context = builder.getContext();
    pageClass = builder.getPageClass();
  }

  @Override
  public PageUIPojo toPojo() {
    return this;
  }

  void addAllTo(PageTitle thatPageTitle) {
    thatPageTitle.resume(this.pageTitle);
  }

  void addAllTo(Breadcrumb thatBreadcrumb) {
    thatBreadcrumb.resume(this.breadcrumb);
  }

  Optional<Reply<?>> reply() {
    PageWay pageWay = injector.getInstance(PageWay.class);
    pageWay.decorate(breadcrumb, pageTitle);
    context.put("way", pageWay);

    Request request = injector.getProvider(Request.class).get();
    Method method = Method.parse(request);

    Pages pages = injector.getInstance(Pages.class);

    Reply<?> reply = method.show(pages, pageClass, context);
    return Optional.<Reply<?>> of(reply);
  }

}