/*
 * Copyright 2014 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui;

import java.util.List;

import br.com.objectos.core.auto.AutoPojo;
import br.com.objectos.way.ui.form.FormResponse;
import br.com.objectos.way.ui.form.FormResponse.Error;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;

import org.codehaus.jackson.JsonGenerator;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
@AutoPojo
public abstract class UserInput implements IsJsonSerializable {

  abstract Optional<Context> context();
  abstract List<Error> errors();
  abstract List<Error> formErrors();
  abstract Optional<String> redirectUrl();

  UserInput() {
  }

  public static UserInputBuilder builder() {
    return new UserInputBuilderPojo();
  }

  public static UserInput redirectTo(String url) {
    return UserInput.builder()
        .context(Optional.<Context> absent())
        .errors(ImmutableList.<FormResponse.Error> of())
        .formErrors(ImmutableList.<FormResponse.Error> of())
        .redirectUrl(Optional.of(url))
        .build();
  }

  public boolean isValid() {
    return errors().isEmpty() && formErrors().isEmpty();
  }

  @Override
  public void toJson(JsonGenerator jgen) {
    WayUI.toJsonHelper(jgen)
        .add("context", context().orNull())
        .add("errors", errors())
        .add("formErrors", formErrors())
        .add("redirectUrl", redirectUrl().orNull())
        .add("valid", isValid())
        .write();
  }

}