/*
 * Copyright 2012 Objectos, Fábrica de Software LTDA.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package br.com.objectos.way.ui.json;

import java.io.IOException;

import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

/**
 * @author marcio.endo@objectos.com.br (Marcio Endo)
 */
public class JodaLocalDateDeserializers {

  private JodaLocalDateDeserializers() {
  }

  public static class ISO extends Deserializer {
    public ISO() {
      super("yyyy-MM-dd");
    }
  }

  public static class DD_MM_YY extends Deserializer {
    public DD_MM_YY() {
      super("dd/MM/yy");
    }
  }

  public static class DD_MM_YYYY extends Deserializer {
    public DD_MM_YYYY() {
      super("dd/MM/yyyy");
    }
  }

  public static class MM_DD_YYYY extends Deserializer {
    public MM_DD_YYYY() {
      super("MM/dd/yyyy");
    }
  }

  private static abstract class Deserializer extends JsonDeserializer<LocalDate> {

    private final DateTimeFormatter formatter;

    public Deserializer(String pattern) {
      formatter = DateTimeFormat.forPattern(pattern);
    }

    @Override
    public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt)
        throws IOException, JsonProcessingException {

      LocalDate res = null;

      JsonToken t = jp.getCurrentToken();

      if (t == JsonToken.VALUE_STRING) {
        try {
          String text = jp.getText().trim();
          res = formatter.parseLocalDate(text);
        } catch (IllegalArgumentException iae) {

        }
      }

      return res;

    }

  }

}